param([string]$InstanceName, [int]$TimePeriod, [string]$CustomSQLName)

if ($TimePeriod -gt 0)
{
$StrLength = 4096

if ($CustomSQLName){$ComputerName=$CustomSQLName}
else {$ComputerName=(Get-WmiObject Win32_Computersystem).name}

if ($InstanceName -match "SQLServer"){$InstanceName = ""}
else {$InstanceName = $InstanceName.Replace('MSSQL$',"")
	$InstanceName = $InstanceName.Replace("'","")
}

$ConnectionString = $ComputerName + '\' + $InstanceName
#write-output "ConnString - $ConnectionString"

$Query = @"
select * from ( select
		j.name as 'JobName',
		run_date,
		run_time,
		msdb.dbo.agent_datetime(run_date, run_time) as 'RunDateTime',
		h.run_duration,
		((run_duration/10000*3600 + (run_duration/100)%100*60 + run_duration%100 + 31 ) / 60) as 'RunDurationMinutes',
		ROW_NUMBER() OVER(PARTITION BY j.name ORDER BY msdb.dbo.agent_datetime(run_date, run_time) DESC) NROW
		From msdb.dbo.sysjobs j 
		INNER JOIN msdb.dbo.sysjobhistory h 
		ON j.job_id = h.job_id 
		where j.enabled = 1  
		AND 
		((run_duration/10000*3600 + (run_duration/100)%100*60 + run_duration%100 + 31 ) / 60) > $TimePeriod
		) t 
		where nrow < 3
"@
try{
    $Datatable = New-Object System.Data.DataTable
    
    $Connection = New-Object System.Data.SQLClient.SQLConnection
    $Connection.ConnectionString = "server=$ConnectionString;database='master';trusted_connection=true;"
    $Connection.Open()
    $Command = New-Object System.Data.SQLClient.SQLCommand
    $Command.Connection = $Connection
    $Command.CommandText = $Query
    $Reader = $Command.ExecuteReader()
    $Datatable.Load($Reader)
    $Connection.Close()
 
#    $Datatable.Rows | FT *


if (($Datatable.rows).count -ge 1)
{
    $FormatedData = $Datatable.Rows | FL | out-string
    if($FormatedData.Length -gt $StrLength) {$FormatedData = $FormatedData.substring(0, $StrLength)}
    write-output $FormatedData
}
else{write-output "Result: none"}
}

Catch
{write-output "Result: none"
$ConnectionString
$Exception = $_.Exception.Message
if($Exception.Length -gt $StrLength) {$Exception = $Exception.substring(0, $StrLength)}
write-output $Exception
}
}
else{write-output "Result: none"}
